#include <stdlib.h>

/*
 * Image title: earth.gif
 * Image size: 0x10 x 0x70
 * Number of tiles (total - unique): 0x1C - 0x1C
 */

unsigned char earth_data[] = {

        /* Tile 0x00 */
	0x07,0x07,0x18,0x1F,0x32,0x2D,0x71,0x4E,0x70,0x4F,0xF8,0x87,0xF8,0x87,0xF8,0x87,
	0xFC,0x83,0xFE,0x81,0x7F,0x40,0x7F,0x40,0x3F,0x20,0x1F,0x18,0x07,0x07,0x00,0x00,
	0xC0,0xC0,0xF0,0x30,0x78,0x88,0x3C,0xC4,0x5C,0xA4,0x9E,0x62,0x3E,0xC2,0x3E,0xC2,
	0x5E,0xA2,0x7E,0x82,0x0C,0xF4,0x0C,0xF4,0x98,0x68,0xB0,0x70,0xC0,0xC0,0x00,0x00,
	0x07,0x07,0x1F,0x18,0x2F,0x30,0x4F,0x70,0x6F,0x50,0x9F,0xE0,0x9F,0xE0,0xBF,0xC0,
	0xFF,0x80,0xB7,0xC8,0x63,0x5C,0x43,0x7C,0x3F,0x20,0x1F,0x18,0x07,0x07,0x00,0x00,
	0xC0,0xC0,0xB0,0x70,0x18,0xE8,0x0C,0xF4,0x0C,0xF4,0x82,0x7E,0x82,0x7E,0x86,0x7A,
	0xC6,0x3A,0xE6,0x1A,0xF4,0x0C,0xFC,0x04,0xF8,0x08,0xF0,0x30,0xC0,0xC0,0x00,0x00,

        /* Tile 0x08 */
	0x07,0x07,0x1E,0x19,0x20,0x3F,0x40,0x7F,0x42,0x7D,0x81,0xFE,0x81,0xFE,0x83,0xFC,
	0xD7,0xA8,0xBB,0xC4,0x6E,0x51,0x7C,0x43,0x3F,0x20,0x1F,0x18,0x07,0x07,0x00,0x00,
	0xC0,0xC0,0x70,0xB0,0xE8,0x18,0xF4,0x0C,0xF4,0x0C,0xFE,0x02,0xFE,0x02,0xFE,0x02,
	0xFE,0x02,0x7E,0x82,0x3C,0xC4,0x3C,0xC4,0xF8,0x08,0xF0,0x30,0xC0,0xC0,0x00,0x00,
	0x07,0x07,0x1B,0x1C,0x20,0x3F,0x40,0x7F,0x40,0x7F,0xE0,0x9F,0x90,0xEF,0x89,0xF6,
	0x8D,0xF2,0x9F,0xE0,0x5E,0x61,0x6F,0x50,0x3F,0x20,0x1F,0x18,0x07,0x07,0x00,0x00,
	0xC0,0xC0,0xB0,0x70,0x28,0xD8,0x04,0xFC,0x2C,0xD4,0x1E,0xE2,0x1E,0xE2,0x3E,0xC2,
	0x7E,0x82,0xB6,0x4A,0xE4,0x1C,0xC4,0x3C,0xF8,0x08,0xF0,0x30,0xC0,0xC0,0x00,0x00,

        /* Tile 0x10 */
	0x07,0x07,0x18,0x1F,0x20,0x3F,0x40,0x7F,0x40,0x7F,0xEE,0x91,0xF1,0x8E,0xE0,0x9F,
	0xE0,0x9F,0xF1,0x8E,0x71,0x4E,0x72,0x4D,0x3F,0x20,0x1F,0x18,0x07,0x07,0x00,0x00,
	0xC0,0xC0,0xF0,0x30,0x08,0xF8,0x04,0xFC,0x04,0xFC,0x02,0xFE,0x02,0xFE,0x92,0x6E,
	0xD6,0x2A,0xFE,0x02,0xEC,0x14,0xFC,0x04,0xF8,0x08,0xF0,0x30,0xC0,0xC0,0x00,0x00,
	0x07,0x07,0x1D,0x1A,0x36,0x29,0x5C,0x63,0x6C,0x53,0xCE,0xB1,0x9F,0xE0,0x9E,0xE1,
	0xAE,0xD1,0xBF,0xC0,0x47,0x78,0x47,0x78,0x2F,0x30,0x1F,0x18,0x07,0x07,0x00,0x00,
	0xC0,0xC0,0x70,0xB0,0x08,0xF8,0x04,0xFC,0x04,0xFC,0xE2,0x1E,0x32,0xCE,0x0E,0xF2,
	0x0E,0xF2,0x1E,0xE2,0x1C,0xE4,0x2C,0xD4,0xF8,0x08,0xF0,0x30,0xC0,0xC0,0x00,0x00,

        /* Tile 0x18 */
	0x07,0x07,0x1E,0x19,0x33,0x2C,0x49,0x76,0x42,0x7D,0xC4,0xBB,0xC1,0xBE,0xC1,0xBE,
	0xE2,0x9D,0xF3,0x8C,0x78,0x47,0x78,0x47,0x3C,0x23,0x1C,0x1B,0x07,0x07,0x00,0x00,
	0xC0,0xC0,0x70,0xB0,0x68,0x98,0xC4,0x3C,0xC4,0x3C,0xEE,0x12,0xF2,0x0E,0xE2,0x1E,
	0xE2,0x1E,0xF2,0x0E,0x7C,0x84,0x7C,0x84,0xF8,0x08,0xF0,0x30,0xC0,0xC0,0x00,0x00
};

/*
 * Image title: bkg.gif
 * Image size: 0x40 x 0x40
 * Number of tiles (total - unique): 0x40 - 0x31
 */

unsigned char bkg_data[] = {

        /* Tile 0x00 */
        0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3F,0x3F,0x3F,0x3F,
        0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
        0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xE3,0xE3,0xE7,0xE7,0xE7,0xE7,0xC7,0xC7,
        0xFF,0xFF,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
        0xFF,0xFF,0xFF,0xFF,0x7F,0x7F,0x7F,0x7F,0x3F,0x3F,0x0F,0x0F,0xC7,0xC7,0xE1,0xE1,
        0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,0xFC,0xFC,
        0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0xF8,
        0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,0xFC,0xFC,0xF1,0xF1,0xC7,0xC7,0x0F,0x0F,0x3F,0x3F,

        /* Tile 0x08 */
        0xC0,0xC0,0x9F,0x9F,0x3F,0x3F,0x7F,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
        0x0F,0x0F,0xC3,0xC3,0xF0,0xF0,0xFC,0xFC,0xFF,0xFF,0xF8,0xF8,0x83,0x83,0x07,0x07,
        0xFF,0xFF,0xFC,0xFC,0x70,0x70,0x03,0x03,0x07,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
        0xF8,0xF8,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
        0xF8,0xF8,0x03,0x03,0x0F,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
        0xFF,0xFF,0xF8,0xF8,0x00,0x00,0x03,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
        0x80,0x80,0x07,0x07,0x3F,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,
        0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,

        /* Tile 0x10 */
        0xFE,0xFE,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xF0,0xF0,0xC3,0xC3,0x0F,0x0F,
        0x27,0x27,0x73,0x73,0xF1,0xF1,0xF8,0xF8,0xFC,0xFC,0x7E,0x7E,0xFE,0xFE,0xFF,0xFF,
        0xF8,0xF8,0xC0,0xC0,0x83,0x83,0x1F,0x1F,0x3F,0x3F,0x7F,0x7F,0x3F,0x3F,0x3F,0x3F,
        0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
        0x1F,0x1F,0x03,0x03,0xE0,0xE0,0xFC,0xFC,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
        0xCF,0xCF,0x80,0x80,0x90,0x90,0x9F,0x9F,0x9F,0x9F,0xDF,0xDF,0xCF,0xCF,0xCF,0xCF,
        0xF8,0xF8,0xF8,0xF8,0x03,0x03,0xC3,0xC3,0xF3,0xF3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
        0x03,0x03,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,

        /* Tile 0x18 */
        0x3F,0x3F,0x3F,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
        0xC7,0xC7,0xC7,0xC7,0xE7,0xE7,0x1F,0x1F,0x07,0x07,0xC3,0xC3,0xFF,0xFF,0xFF,0xFF,
        0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE7,0xE7,
        0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,0xFE,0xFE,0xFF,0xFF,0xFF,0xFF,
        0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3F,0x3F,0x1F,0x1F,0x1F,0x1F,0x3F,0x3F,0xFF,0xFF,
        0xE0,0xE0,0xE0,0xE0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,0xFE,0xFE,0xFF,0xFF,
        0x00,0x00,0x00,0x00,0x80,0x80,0xF9,0xF9,0x81,0x81,0x0F,0x0F,0x1F,0x1F,0x80,0x80,
        0xFF,0xFF,0xFF,0xFF,0x1F,0x1F,0x80,0x80,0xF0,0xF0,0xFF,0xFF,0x0F,0x0F,0xFF,0xFF,

        /* Tile 0x20 */
        0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0xFC,0xF8,0xF8,0xF1,0xF1,0xE3,0xE3,
        0xC3,0xC3,0xC3,0xC3,0xE7,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,
        0xFF,0xFF,0xFF,0xFF,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0x98,0x98,0x67,0x67,
        0xFF,0xFF,0xFF,0xFF,0xFC,0xFC,0x61,0x61,0x7E,0x7E,0x7F,0x7F,0xFF,0xFF,0xFF,0xFF,
        0xFE,0xFE,0xC0,0xC0,0x18,0x18,0xFC,0xFC,0x00,0x00,0xFC,0xFC,0xF0,0xF0,0x81,0x81,
        0x0F,0x0F,0x0F,0x0F,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
        0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
        0xE7,0xE7,0xEF,0xEF,0xE8,0xE8,0xE0,0xE0,0xE6,0xE6,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,

        /* Tile 0x28 */
        0xFF,0xFF,0xFF,0xFF,0x7F,0x7F,0x7F,0x7F,0x7C,0x7C,0x7F,0x7F,0x78,0x78,0x60,0x60,
        0xF9,0xF9,0xE7,0xE7,0x9F,0x9F,0x7E,0x7E,0xE0,0xE0,0xC0,0xC0,0x8D,0x8D,0x1D,0x1D,
        0xDF,0xDF,0xBF,0xBF,0x7F,0x7F,0xFF,0xFF,0x00,0x00,0x00,0x00,0xCF,0xCF,0xC7,0xC7,
        0xFF,0xFF,0xFE,0xFE,0xF8,0xF8,0xF1,0xF1,0x03,0x03,0x1F,0x1F,0xFF,0xFF,0xFF,0xFF,
        0x0F,0x0F,0x7F,0x7F,0x7F,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
        0xFE,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
        0x06,0x06,0x0F,0x0F,0xBF,0xBF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
        0x1B,0x1B,0xFB,0xFB,0xF7,0xF7,0xF7,0xF7,0xEF,0xEF,0xDF,0xDF,0xFF,0xFF,0xFF,0xFF,

        /* Tile 0x30 */
        0xE7,0xE7,0xE7,0xE7,0xE7,0xE7,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3
};

unsigned char bkg_tiles[] = {
        0x00,0x01,0x01,0x02,0x01,0x03,0x04,0x05,
        0x01,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,
        0x0D,0x0E,0x0F,0x10,0x11,0x12,0x13,0x14,
        0x15,0x16,0x17,0x01,0x01,0x18,0x01,0x01,
        0x19,0x01,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
        0x20,0x01,0x21,0x22,0x23,0x24,0x25,0x26,
        0x27,0x28,0x29,0x2A,0x2B,0x2C,0x01,0x01,
        0x2D,0x2E,0x2F,0x30,0x01,0x01,0x01,0x01
};

void main()
{
  int i, j, x, y, t;

  /* Initialize the background */
  set_bkg_data(0x00, 0x31, bkg_data);
  for(i = 0; i < 32; i+=8)   /* Width = 0x100 = 0x20 * 8 */
    for(j = 0; j < 32; j+=8)   /* Height = 0x100 = 0x20 * 8 */
      set_bkg_tiles(i, j, 8, 8, bkg_tiles);
  show_bkg();

  x = y = 64;

  sprites8x16();   /* sprites are 8x16 */
  set_sprite_data(0x00, 0x1C, earth_data);
  set_sprite_tile(0, 0x00);
  set_sprite_tile(1, 0x02);
  move_sprite(0, x, y);
  move_sprite(1, x+8, y);
  show_sprites();
  display_on();
  enable_interrupts();

  t = 0;
  j = 0;
  while(1) {
    delay(1000);
    i = joypad();
    if(i & J_START) {
      break;
    }
    if(i & J_UP)
      y--;
    if(i & J_DOWN)
      y++;
    if(i & J_LEFT)
      x--;
    if(i & J_RIGHT)
      x++;

    if(t%8 == 0)
      scroll_bkg(2, 1);

    if(t%16 == 0) {
      set_sprite_tile(0, t/16*4);
      set_sprite_tile(1, t/16*4+2);
    }

    if(i & (J_UP | J_DOWN | J_LEFT | J_RIGHT)) {
      move_sprite(0, x, y);
      move_sprite(1, x+8, y);
    }
    t++;
    if(t/16 >= 7)
      t = 0;
  }
}
